const database = require("@database");
const utils = require("@utils");

const getInfoAuthentication = async (req, res) => {
  try {
    const { ugid, email } = req.user;

    const userData = await database("user_data")
      .where({ ugid })
      .first();

    if (!userData) {
      return utils.responseSnippet(res, 404, "User not found.", null);
    }

    const userAccess = await database("user_access")
      .where({ ugid })
      .first();

    const userDevices = await database("user_devices")
      .where({ ugid })
      .select(
        "device_id",
        "device_name",
        "device_type",
        "last_active",
        "is_online",
        "created_at"
      );

    const isAdmin = await database("admin_list")
      .where({ ugid })
      .first();

    const userInfo = {
      ugid: userData.ugid,
      username: userData.username,
      name: userData.name,
      email: userData.email,
      language: userData.language,
      timeJoined: userData.time_joined,
      lastIP: userData.last_ip,
      profilePictureKey: userData.profile_picture_key,
      profilePictureFormat: userData.profile_picture_format,
      accessLevel: userAccess ? userAccess.authorized_modules : null,
      devices: userDevices || [],
      isAdmin: !!isAdmin,
    };

    utils.responseSnippet(
      res,
      200,
      "User information retrieved successfully.",
      userInfo
    );
  } catch (error) {
    console.error("Get user info error:", error);

    console.log(error);
    res.status(500).json({
      message: "A problem happened while processing your request!",
      data: null,
    });
  }
};

module.exports = getInfoAuthentication;
