const database = require("@database");
const utils = require("@utils");

const getUsersManagement = async (req, res) => {
  try {

    const users = await database("user_data")
      .select(
        "user_data.ugid",
        "user_data.username",
        "user_data.name",
        "user_data.email",
        "user_data.time_joined",
        "user_data.language",
        "user_data.last_ip",
        "user_access.authorized_modules"
      )
      .leftJoin("user_access", "user_data.ugid", "user_access.ugid");


    if (!users || users.length === 0) {
      return utils.responseSnippet(res, 200, "No users found.", []);
    }

    const blockedUsers = await database("user_blocked_list").select(
      "ugid"
    );

    const adminUsers = await database("admin_list").select("ugid");

    const blockedUgids = new Set(blockedUsers.map((u) => u.ugid));
    const adminUgids = new Set(adminUsers.map((u) => u.ugid));

    const formattedUsers = users.map((user) => ({
      ...user,
      is_blocked: blockedUgids.has(user.ugid),
      is_admin: adminUgids.has(user.ugid),
      authorized_modules: user.authorized_modules
        ? user.authorized_modules.split(",")
        : [],
    }));


    utils.responseSnippet(
      res,
      200,
      "Users retrieved successfully.",
      formattedUsers
    );
  } catch (error) {
    console.error("Get users error - Full error:", error);
    console.error("Error stack trace:", error.stack);
    utils.catchErrorHandlerSnippet(
      res,
      error,
      "get_users.user_management.js"
    );
  }
};

module.exports = getUsersManagement;
