const { express, Joi } = require("@packages");
const {
  schemavalidator,
  tokenvalidator,
  accessvalidator,
  isadmin,
} = require("@middlewares");
const config = require("@config");
const userManagementRouter = express.Router();
const getUsersManagement = require("../controllers/user_management/get_users.user_management.js");

userManagementRouter.get(
  "/list",
  tokenvalidator,
  isadmin(),
  accessvalidator("user_management"),
  (req, res) => {
    console.log(
      `[${new Date().toISOString()}] GET /user_management/list - Request received`
    );
    getUsersManagement(req, res);
  }
);

userManagementRouter.post(
  "/register",
  tokenvalidator,
  isadmin(),
  accessvalidator("user_management"),
  schemavalidator.SchemaValidator(
    "body",
    Joi.object({
      email: Joi.string().label("Email").email().max(30).required(),
      name: Joi.string().label("Name").max(50).required(),
      is_admin: Joi.boolean().default(false),
      authorized_modules: Joi.array()
        .items(
          Joi.string().valid(
            "all",
            "qr",
            "analyse",
            "user_management"
          )
        )
        .required(),
    }).unknown(false)
  ),
  (req, res) => {
    require("../controllers/user_management/register_user.user_management.js")(
      req,
      res
    );
  }
);

userManagementRouter.get(
  "/:ugid",
  tokenvalidator,
  isadmin(),
  accessvalidator("user_management"),
  schemavalidator.SchemaValidator(
    "params",
    Joi.object({
      ugid: Joi.string().required(),
    }).unknown(false)
  ),
  (req, res) => {
    require("../controllers/user_management/get_user.user_management.js")(
      req,
      res
    );
  }
);

userManagementRouter.put(
  "/:ugid",
  tokenvalidator,
  isadmin(),
  accessvalidator("user_management"),
  schemavalidator.SchemaValidator(
    "params",
    Joi.object({
      ugid: Joi.string().required(),
    }).unknown(false)
  ),
  schemavalidator.SchemaValidator(
    "body",
    Joi.object({
      name: Joi.string().label("Name").max(50).required(),
      is_admin: Joi.boolean(),
      authorized_modules: Joi.array().items(
        Joi.string().valid("all", "qr", "analyse", "user_management")
      ),
    }).unknown(false)
  ),
  (req, res) => {
    require("../controllers/user_management/update_user.user_management.js")(
      req,
      res
    );
  }
);

userManagementRouter.delete(
  "/:ugid",
  tokenvalidator,
  isadmin(),
  accessvalidator("user_management"),
  schemavalidator.SchemaValidator(
    "params",
    Joi.object({
      ugid: Joi.string().required(),
    }).unknown(false)
  ),
  (req, res) => {
    require("../controllers/user_management/delete_user.user_management.js")(
      req,
      res
    );
  }
);

userManagementRouter.post(
  "/block/:ugid",
  tokenvalidator,
  isadmin(),
  accessvalidator("user_management"),
  schemavalidator.SchemaValidator(
    "params",
    Joi.object({
      ugid: Joi.string().required(),
    }).unknown(false)
  ),
  (req, res) => {
    require("../controllers/user_management/block_user.user_management.js")(
      req,
      res
    );
  }
);

module.exports = userManagementRouter;
