// Imports
// -------------------------------
const { src, dest, series } = require("gulp");
const uglify = require("gulp-uglify");

function minifyJs(cb) {
    // Minify and copy JS files other than server.js to dist/
    src(["./src/**/*.js"])
        .pipe(uglify())
        .pipe(dest("./dist/"));

    // Minify and copy server.js from project root to project root (effectively overwriting it)
    src("./server.js")
        .pipe(uglify())
        .pipe(dest("./"));
    
    cb();
}

function copyEnvFile(cb) {
  src("./src/**/production.env").pipe(dest("./dist/"));
  cb();
}

exports.default = series(minifyJs, copyEnvFile);
