/**
 * Get Sessions Controller
 *
 * Returns all presentation sessions for the authenticated user
 * - Retrieves from database ordered by recording date (newest first)
 * - Returns empty array if no sessions found
 * - Includes session metadata and scores
 */

const database = require("@database");
const utils = require("@utils");

const getSessions = async (req, res) => {
  try {
    // Get user UGID from token
    const { ugid } = req.user;

    // Fetch all sessions for the user
    const sessions = await database("presentation_session")
      .where({ ugid })
      .select(
        "id",
        "session_name",
        // "locale", // REMOVED
        // "presentation_id", // REMOVED
        "recording_date",
        "session_length",
        // "status", // REMOVED
        // "analysis_status", // REMOVED
        "overall_score"
        // "created_at", // REMOVED
        // "updated_at" // REMOVED
      )
      .orderBy("recording_date", "desc");

    return utils.responseSnippet(
      res,
      200,
      "Sessions retrieved successfully",
      sessions || []
    );
  } catch (error) {
    console.error("Get sessions error:", error);
    return utils.catchErrorHandlerSnippet(res, error, __dirname);
  }
};

module.exports = getSessions;
