const { responseSnippet } = require("@utils");

const SchemaValidator = (prop, schema) => {
  return async (req, res, next) => {
    try {
      if (!["body", "params", "query", "headers"].includes(prop)) {
        return responseSnippet(res, 400, "Invalid request property type", null);
      }

      if (!schema) {
        return responseSnippet(res, 500, "No validation schema provided", null);
      }

      const dataToValidate = req[prop] || {};

      await schema.validateAsync(dataToValidate, {
        abortEarly: false,
        allowUnknown: prop === "headers",
      });

      return next();
    } catch (error) {
      if (error.isJoi) {
        const errors = error.details.map((detail) => ({
          field: detail.path.join("."),
          message: detail.message.replace(/"/g, ""),
        }));

        return responseSnippet(res, 400, "Validation failed", { errors });
      }

      return responseSnippet(res, 500, "Internal validation error", null);
    }
  };
};

module.exports = { SchemaValidator };
