// Imports
// -------------------------------
const config = require("../../config");

// Initialize database connection
// -------------------------------
const isProduction = process.env.NODE_ENV === 'production';

const connectionConfig = {
  host: config.db.host,
  port: config.db.port,
  user: config.db.user,
  password: config.db.password,
  database: config.db.name,
};

// Add SSL for Azure MySQL in production
if (isProduction) {
  connectionConfig.ssl = {
    rejectUnauthorized: false // For Azure MySQL
  };
}

const database = require('knex')({
  client: config.db.client,
  connection: connectionConfig,
  pool: { min: 2, max: 10 },
  acquireConnectionTimeout: 60000
});

// Test connection on initialization
database.raw('SELECT 1')
  .then(() => {
    console.log('Database connection established');
  })
  .catch(err => {
    console.error('Database connection failed:', err);
    console.log('Continuing without database for contact service testing...');
    // process.exit(1); // Temporarily disabled for contact service testing
  });

module.exports = database;